#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include "DCI_Close.h"
#include "windows.h"
#include <time.h>
#include <psapi.h>
#include <assert.h>
using namespace std;

typedef long long           int64_t;
typedef unsigned long long	uint64_t;
/// ȡǰڴڴʹ-1ʧܣ0ɹ
int get_memory_usage(uint64_t* mem, uint64_t* vmem);
/// ȡǰܹдIOֽ-1ʧܣ0ɹ
int get_io_bytes(uint64_t* read_bytes, uint64_t* write_bytes);
/// ʱת
static uint64_t file_time_2_utc(const FILETIME* ftime)
{
	LARGE_INTEGER li;

	assert(ftime);
	li.LowPart = ftime->dwLowDateTime;
	li.HighPart = ftime->dwHighDateTime;
	return li.QuadPart;
}
int get_memory_usage(uint64_t* mem, uint64_t* vmem)
{
	PROCESS_MEMORY_COUNTERS pmc;
	if(GetProcessMemoryInfo(GetCurrentProcess(), &pmc, sizeof(pmc)))
	{
		if(mem) *mem = pmc.WorkingSetSize;
		if(vmem) *vmem = pmc.PagefileUsage;
		return 0;
	}
	return -1;
}

int get_io_bytes(uint64_t* read_bytes, uint64_t* write_bytes)
{
	IO_COUNTERS io_counter;
	if(GetProcessIoCounters(GetCurrentProcess(), &io_counter))
	{
		if(read_bytes) *read_bytes = io_counter.ReadTransferCount;
		if(write_bytes) *write_bytes = io_counter.WriteTransferCount;
		return 0;
	}
	return -1;
}

char* getCurrentDir()                          //õǰ·vs2005
{
	wchar_t currentdirectory[100];
    ::GetCurrentDirectoryW(100, currentdirectory);
	DWORD dwNum = WideCharToMultiByte(CP_OEMCP,NULL,currentdirectory,-1,NULL,0,NULL,FALSE);
    char *psText = new char[dwNum];
    WideCharToMultiByte (CP_OEMCP,NULL,currentdirectory,-1,psText,dwNum,NULL,FALSE);

	return psText;
}

int main()
{
	char *fn = getCurrentDir();          //ʼȡĿļ·
	strcat(fn, "\\T10D100k.data.txt");
	char *pfn = getCurrentDir();         //ʼȡĿļ·
	strcat(pfn, "\\Item100.data.pro");
	char *ofn = getCurrentDir();         //ļ·
	strcat(ofn, "\\o.txt");
	float threshold = 0.05;                     //default min_util = 0

	clock_t start = clock();
	DCI_Close dci;
	dci.setItemProfit(pfn);
	dci.setData(fn);
	dci.setOutput(ofn);
	dci.setMinUtil(threshold);
	dci.setVerbose();
	dci.generateCloseSets();
	cout << "\t[" << (clock()-start)/double(CLOCKS_PER_SEC) << "s]" << endl;
	cout << "HUI: " << dci.getResultnum() << endl;
	cout << "MTWU: " << dci.total << endl;
	cout << "HTWUI: " << dci.htwui << endl;

	uint64_t mem, vmem, r, w;

	get_memory_usage(&mem, &vmem);
	get_io_bytes(&r, &w);

	printf("ڴʹ: %u kֽ\n", mem/1024);
	system("PAUSE");
	return 0;
}